#!/bin/bash
#
# restarts a remote windows service via rpc

# define usage function
usage()
    {
        echo "usage $0 (-h <help>) -H <host_address> -u <user_id> -p <user_password> -n <service_name> -s <service_state_id>"
    }

# exit when option string does not begin with a '-'
if [[ ! $@ =~ ^\-.+ ]]
then
  usage
fi

# execute getopt on the arguments passed to this program, identified by the special character $@
OPTS=$(getopt -n "$0" -o hH:u:p:n:s: -- "$@")

# bad arguments, something has gone wrong with the getopt command.
if [ $? -ne 0 ];
then
    exit 1
fi

# little magic, necessary when using getopt.
eval set -- "$OPTS"

# Now goes through all the options with a case and using shift to analyse 1 argument at a time.
# $1 identifies the first argument, and when we use shift we discard the first argument, so $2 becomes $1 and goes again through the case.
# go through all options
while true;
do
    case "$1" in
        -h)
            usage
            shift;;
        -H)
            # We need to take the option of the argument "-h"
            HOST_ADDRESS=$2
            shift 2;;
        -u)
            USER_ID=$2
            shift 2;;
        -p)
            USER_PASSWORD=$2
            shift 2;;
        -n)
            SERVICE_NAME=$2
            shift 2;;
        -s)
            SERVICE_STATE_ID=$2
            shift 2;;
        --)
            shift
            break;;
    esac
done

if [ ! $SERVICE_STATE_ID == 0 ]
then
    net rpc service start "$SERVICE_NAME" -I $HOST_ADDRESS -U "$USER_ID%$USER_PASSWORD" > /dev/null 2> /dev/null
fi